<?php
	// Ausgabepuffer starten um Ausgaben vor header() zu verhindern
	ob_start();

	// Config-Datei und BB-Code-File einbinden
	include('myGB-config.inc.php');
	include('myGB/myGB-lib/bbcode.php');
	
	// Pfad zu den Smilies
	// "/" anhngen falls ein Odner angegeben wurde;
	if($smileypath != '') $smileypath .= '/'; 
	
	if(strtolower($captchatest) == 'on')
	{
		if(isset($_POST['send']))
		{
			if(trim($_POST['myGBcode']) == $_REQUEST['l'] AND isset($_POST['myGBcode'])) $inserttest = true;
			else $inserttest = false;
		}
	}
	else $inserttest = true;

	if(isset($_POST['send']) and $inserttest == true)
	{
		header("Location: ?page=1");

		//Alles in eine Variable hintereinander schreiben
		if(trim($_POST['myGBname']) == '') $_POST['myGBname'] = 'Anonymous';
		$GBeintrag = str_replace('|', '&#9474;', $_POST['myGBname'])."|"; // der Name aus dem Formular
		$GBeintrag .= str_replace('|', '&#9474;', $_POST['myGBhp'])."|"; // die Website aus dem Formular
		$GBeintrag .= str_replace('|', '&#9474;', $_POST['myGBmail'])."|"; // die Mail-Adresse aus dem Formular
		$GBeintrag .= date("d.m.y")."|"; // das Datum aus dem Formular, gleich formatiert
	
		/*
		Das Zeichen '|' wird als Trennzeichen in der Textdatei des Gstebuchs verwendet.
		Falls jemand in der nachricht ein | verwendet hat, wird es hier durch HTML ersetzt.
		*/
		$_POST['myGBtext'] = str_replace("|", "&#9474;", $_POST['myGBtext']);
	  
		//Alle HTML-Tags des benutzers "entschrfen"
		$_POST['myGBtext'] = str_replace("<","&lt;",$_POST['myGBtext']);
		$_POST['myGBtext'] = str_replace(">","&gt;",$_POST['myGBtext']);
		
		// berprfen, ob magic_quotes aktiv ist, falls ja, Slashes entfernen
		if(get_magic_quotes_gpc()) $_POST['myGBtext'] = stripslashes($_POST['myGBtext']);
	
		// Zeilenumbrche ersetzen, da anhand dieser sonst die Trennung der Datenstze erfolgen wrde
		$_POST['myGBtext'] = str_replace("\r\n", "<br>", $_POST['myGBtext']);
		$_POST['myGBtext'] = str_replace("\r", "<br>", $_POST['myGBtext']);
		$_POST['myGBtext'] = str_replace("\n", "<br>", $_POST['myGBtext']);
		
		// Anfhrungszeichen als Sonderzeichen behandeln
		$_POST['myGBtext'] = addslashes($_POST['myGBtext']);
	
		// Umbruch als Trennzeichen am Ende des Datensatzes hinzufgen
		$GBeintrag .= $_POST['myGBtext']."\r\n";
		
		/*
		Den Eintrag in die Textdatei schreiben und dabei vor
		gleichzeitigem Mehrfachzugriff schtzen
		*/
		$openfile = fopen($textfile, "a");
		flock($openfile, 2);
		fwrite($openfile, $GBeintrag);
		flock($openfile, 3);
		fclose($openfile);

	}	
?>
<!--
	Copyright (C) 2005-2007 by Computerhilfen.de

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, see < http://www.gnu.org/licenses/ >
	
 ############################################################################
 
	Dieses Gstebuch wurde in einer Gemeinschaftsarbeit mehrerer
	Mitglieder von computerhilfen.de entwickelt. Es soll all jenen,
	die sich immer wieder fragen: "Gstebuch? Wie geht das?" zeigen,
	wie man ein einfaches Gstebuch erstellt.
	Es ist auch nicht das ultimative Gstebuch, sondern nur ein Wink
	in die richtige Richtung. Im Detail waren daran beteiligt:

	# Erster Entwurf und Grundfunktionen sowie Anfnge des Adminbereichs:
		- Jan190480
	# Optimierung des Lese- und Schreibzugriffs:
		- JoSsiF, Mario
	#Verteilung der Eintrge auf mehrere Seiten:
		- Spawn
	#Stylesheet-Implementierung und Erweiterung des Adminbereichs, (Erweiterter) BB-Code Filter:
		- Der olle Schwoebel

	Viel Spa mit dem Gstebuch. Fragen knnen gerne
	direkt an die einzelnen Mitglieder gerichtet werden
	oder im Forum gepostet werden.

	2005-2007 | computerhilfen.de

 ############################################################################
-->
<?php
	/*
	$page initialisieren (der Wert entspricht der aktuellen Seite der Gstebucheintrge)
	Beim ersten Aufruf (keine Seite gewhlt) wird diese auf 1 gesetzt
	
	Die Variable wird immer aus dem superglobalen Array $_REQUEST[] herausgezogen,
	um auch auf solchen Servern einen Wert zu erhalten, auf denen die PHP-Variable
	'register_gobals' auf 'Off' gesetzt ist
	*/
	if (!isset($_REQUEST['page'])) $page = 1;
	else $page = $_REQUEST['page'];
	
	// berprfung ob eine Head-Datei eingebunden werden soll, sonst "Standardheader"
	if($including == 'on')
	{
		if(isset($includingpath_header) and trim($includingpath_header) != '') { include($includingpath_header); }
		else if(isset($includingpath) and trim($includingpath) != '')  { include($includingpath); }
	}
	else
	{
?><!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html><head>
	<title><?php echo $titel;?></title>
</head>
<body>
<?php
	}
	// Ausgabepuffer leeren
	ob_end_flush();
?>
	<link rel="stylesheet" href="myGB/myGB-lib/chgbstyle.php" type="text/css">
	<div style="margin: 0px; padding: 0px; width: 98%; text-align: center">
<?php
	// Falls der User gerade nicht beim "Eintragen"-Teil ist, hier Link ausgeben zum Eintragen
	if((!isset($_REQUEST['action'])) or(isset($_REQUEST['action']) and $_REQUEST['action'] != 'eintragen'))
	{
?>
	<div class="links" style="padding-top: 2em;">
		<b><a href="?action=eintragen">Ins Gstebuch eintragen</a></b><br><br>
	</div>
<?php
	/*
	Hier das Gstebuch ffnen und alle Eintrge in ein Array einlesen;
	Fehlermeldung bei noch nicht vorhandener Datei wird unterdrckt
	und die Datei automatisch angelegt
	*/
	$eintraege = @file($textfile);
	/*
	Anzeigen der Eintrge

	Solange Eintrge vorhanden sind, wird eine Schleife durchlaufen
	von hinten nach vorne (also neueste zuerst)

	Hier wird gleichzeitig die Logik fr die dynamische Generierung
	der Seitenlinks erzeugt
	*/
	$start = (count($eintraege) - 1) - $seiten * ($page - 1);
	$stop = (count($eintraege) - 1) - $seiten * ($page - 1) - $seiten + 1;
	
	if ($start > (count($eintraege) - 1)) $start = count($eintraege) - 1;
	
	if ($stop < 0) $stop = 0;

	// Textdatei berhaupt vorhanden?
	if (!$eintraege) $max = 0; //  $max gibt die Anzahl der Eintrge an
	else
	{
		$max = count($eintraege);
		for ($a = $start; $a >= $stop; $a--)
		{
		// Die einzelnen Teile des Eintrags extrahieren
		$Eintrag = explode('|', $eintraege[$a]);
   
		//und jetzt alles in Tabellen ausgeben
?>
		<table class="guestbook" cellpadding="0" cellspacing="0" style="width: 95%;">
		<tr>
		<td class="guestbook" style="width: <?php echo $zelle_name?>"> von: <b><?php echo $Eintrag[0]?></b> </td>
		<td class="guestbook" style="width: <?php echo $zelle_datum?>"> am : <b><?php echo $Eintrag[3]?></b> </td>
		<td class="guestbook" style="width: <?php echo $zelle_hpemail?>"><?php if(trim($Eintrag[2]) != ''){?> <a href="mailto:<?php echo $Eintrag[2]?>"><img src="<?php echo $smileypath;?>/mail.gif" alt="email"></a> <?php } else echo "&nbsp;"; ?></td>
		<td class="guestbook" style="width: <?php echo $zelle_hpemail?>"><?php if((trim($Eintrag[1]) != '') and (trim($Eintrag[1]) != "http://")){?> <a href="<?php echo $Eintrag[1]?>" target="_blank"><img src="<?php echo $smileypath;?>/hpage.gif" alt="Homepage"></a> <?php } else echo "&nbsp;"; ?></td>
		</tr>
		<tr>
		<td style="padding: 0.3em;" colspan="4" class="inhalt"><?php echo myGB_bbcodesmilie(stripslashes(nl2br($Eintrag[4]))) ?></td>
		</tr>
		</table>
		<br>
<?php
		}
	}
?>
	<div class="links">
<?php

	//  jetzt noch fix die daraus resultierenden Seiten berechnen
	if( !isset($max) or trim($max) == '' ) $max = 0;
	
	if ($max == 0) $pages = 1;
	else $pages = intval(($max - 1) / $seiten) + 1;

	// Links zu den einzelnen Seiten ausgeben
	if ($page > 1)
	{
		echo ' <a href="'.$_SERVER['PHP_SELF'].'?page=1">|<</a> ';
		echo ' <a href="'.$_SERVER['PHP_SELF'].'?page='.($page - 1).'"><</a> ';
	}

	for ($i = 1; $i <= $pages; $i++)
	{
		if ($i == $page) echo ' <b>['.$i.']</b> ';
		else echo ' <a href="'.$_SERVER['PHP_SELF'].'?page='.$i.'">'.$i.'</a> ';
	}

	if($page < $pages)
	{
		echo ' <a href="'.$_SERVER['PHP_SELF'].'?page='.($page + 1).'"><</a> ';
		echo ' <a href="'.$_SERVER['PHP_SELF'].'?page='.$pages.'">>|</a> ';
	}
?>
	</div>
	<br>Es sind <b><?php echo $max?></b> Eintr&auml;ge im G&auml;stebuch<br><br>
<?php
	}
	// Ab hier der "Eintragen"-Teil
	else if(isset($_REQUEST['action']) and $_REQUEST['action'] == 'eintragen')
	{
?>

		<script type="text/javascript" language="JavaScript" src="myGB/myGB-lib/insert.php"></script>
		<script type="text/javascript" language="JavaScript" src="myGB/myGB-lib/eingabeinterface.php"></script>
		
		<div class="links" style="padding-top: 2em;">
		<a href="<?php echo $guestbook; ?>">Zurck zum Gstebuch</a>
		</div><br><br>
	
<?php
		// Rechenaufgabe und Lsung fr Rechenaufgabe ausrechnen
		$zahl1 = rand(10,21);
		$zahl2 = rand(1,9);
		$vorzeichen = rand(1,2);
		if($vorzeichen == 1)
		{
			$loesung = $zahl1 + $zahl2;
			$string = 'vpx'.($zahl1+10).'x'.($zahl2+10);
		}
		else
		{
			$loesung = $zahl1 - $zahl2;
			$string = 'vmx'.($zahl1+10).'x'.($zahl2+10);
		}
?>
		<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="POST" name="eform">

			<table class="guestbook" cellpadding="0" cellspacing="0">
			<tr>
				<td class="inhalt" style="padding: 0.2em;" colspan="2"><b>Hier ins G&auml;stebuch eintragen</small></b></td>
			</tr>
<?php
		if(strtolower($captchatest) == 'on')
		{
?>
			<tr>
				<td class="inhalt" style="padding: 0.2em"><img src="myGB/myGB-lib/captcha.php?string=<?php echo $string; ?>"></td>
				<td class="inhalt" style="padding: 0.2em"><input name="myGBcode" style="width: 300px" tabindex="1"></td>
			</tr>
<?php
		}
?>
			<tr>
				<td class="inhalt" style="padding: 0.2em;">Dein Name</td>
				<td class="inhalt" style="padding: 0.2em;"><input name="myGBname" style="width: 300px" tabindex="2"></td>
			</tr>
			<tr>
				<td class="inhalt" style="padding: 0.2em;">Deine Homepage</td>
				<td class="inhalt" style="padding: 0.2em;"><input name="myGBhp" value="http://" style="width: 300px" tabindex="3"></td>
			</tr>
			<tr>
				<td class="inhalt" style="padding: 0.2em;">Deine Email</td>
				<td class="inhalt" style="padding: 0.2em;"><input name="myGBmail" style="width: 300px" tabindex="4"></td>
			</tr>
			<script type="text/javascript" language="JavaScript">bbcodeinterface();</script>
				<td class="inhalt" style="padding: 0.2em;"><textarea name="myGBtext" onBlur="textarea_name = this.name" style="width: 300px; height: 200px" tabindex="5"></textarea></td>
			</tr>
			<tr>
				<td class="inhalt" style="padding: 0.2em;" colspan="2" align="center"><input type="button" value="Eintragen" tabindex="6" onclick="validate()"></td>
			</tr>
			</table>
			<input type="hidden" name="send">
			<input type="hidden" name="l" value="<?php echo $loesung; ?>">

		</form>
<?php
	}
?>
	<div class="links"><small><a href="myGB/myGB-admin/index.php" target="_blank">Administrationsbereich</a></small></div>
  
	</div>   

<?php
	// Bottom-Datei einbinden
	if($including == 'on' and trim($includingpath_bottom) != '')
	{
		include($includingpath_bottom);
	}
?>